/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.core.v2_1.graphics;

import com.roguewave.chart.core.v2_1.graphics.Line3D;
import com.roguewave.chart.core.v2_1.graphics.Point3D;
import com.roguewave.chart.core.v2_1.graphics.Transform3D;
import com.roguewave.chart.core.v2_1.graphics.XY;
import java.awt.Graphics;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Vector;

class Font3DChar
implements Serializable {
    private static final char SKIPCHAR = ' ';
    XY[] points_;
    int minX_;
    int minY_;
    int maxX_;
    int maxY_;

    Font3DChar(XY[] xYArray, int n, int n2, int n3, int n4) {
        this.points_ = xYArray;
        this.minX_ = n;
        this.minY_ = n2;
        this.maxX_ = n3;
        this.maxY_ = n4;
    }

    public static Font3DChar loadChar(InputStream inputStream) {
        XY[] xYArray;
        if (Font3DChar.getNDigitInt(inputStream, 5) == -1) {
            return null;
        }
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        try {
            int n5 = Font3DChar.getNDigitInt(inputStream, 3);
            xYArray = new XY[n5];
            int n6 = 0;
            while (n6 < n5) {
                int n7 = inputStream.read();
                if (n7 == 10) {
                    n7 = inputStream.read();
                }
                int n8 = inputStream.read();
                if (n6 == 0) {
                    n = n2 = n7;
                    n3 = n4 = n8;
                } else if (n7 != 32) {
                    if (n7 < n) {
                        n = n7;
                    } else if (n7 > n2) {
                        n2 = n7;
                    }
                    if (n8 < n3) {
                        n3 = n8;
                    } else if (n8 > n4) {
                        n4 = n8;
                    }
                }
                xYArray[n6] = new XY(n7, n8);
                ++n6;
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return new Font3DChar(xYArray, n, n3, n2, n4);
    }

    Vector lines(Point3D point3D, int n, int n2, Transform3D transform3D) {
        Vector<Line3D> vector = new Vector<Line3D>();
        boolean bl = true;
        Point3D point3D2 = null;
        int n3 = 0;
        while (n3 < this.points_.length) {
            boolean bl2;
            double d = n + this.points_[n3].x_ - this.minX_;
            double d2 = this.points_[n3].y_ - n2;
            Point3D point3D3 = transform3D.transform(new Point3D(d, d2, 0.0));
            boolean bl3 = bl2 = this.points_[n3].x_ == 32;
            if (n3 > 1 && !bl2 && !bl) {
                vector.addElement(new Line3D(point3D.plus(point3D2), point3D.plus(point3D3)));
            }
            point3D2 = point3D3;
            bl = bl2;
            ++n3;
        }
        return vector;
    }

    Vector lines(double d, double d2, double d3, int n, double d4, double d5) {
        Vector<Line3D> vector = new Vector<Line3D>();
        double d6 = 0.0;
        double d7 = 0.0;
        boolean bl = false;
        int n2 = 0;
        while (n2 < this.points_.length) {
            boolean bl2;
            double d8 = d + (double)(this.points_[n2].x_ - this.minX_) * d4;
            double d9 = d2 + (double)(this.points_[n2].y_ - n) * d5;
            boolean bl3 = bl2 = this.points_[n2].x_ == 32;
            if (n2 > 1 && !bl2 && !bl) {
                vector.addElement(new Line3D(new Point3D(d6, d7, d3), new Point3D(d8, d9, d3)));
            }
            d6 = d8;
            d7 = d9;
            bl = bl2;
            ++n2;
        }
        return vector;
    }

    void draw(Graphics graphics, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        int n5 = 0;
        while (n5 < this.points_.length) {
            boolean bl2;
            int n6 = n + this.points_[n5].x_ - this.minX_;
            int n7 = n2 + this.points_[n5].y_;
            boolean bl3 = bl2 = this.points_[n5].x_ == 32;
            if (n5 > 1 && !bl2 && !bl) {
                graphics.drawLine(n3, n4, n6, n7);
            }
            n3 = n6;
            n4 = n7;
            bl = bl2;
            ++n5;
        }
    }

    static int getNDigitInt(InputStream inputStream, int n) {
        int n2;
        int n3;
        int n4;
        char[] cArray = new char[n];
        try {
            while ((n4 = inputStream.read()) == 10) {
            }
            if (n4 == -1 || n4 != 32 && !Character.isDigit((char)n4)) {
                return -1;
            }
            cArray[0] = (char)n4;
            n3 = 1;
            while (n3 < n) {
                n4 = inputStream.read();
                if (n4 == -1 || n4 != 32 && !Character.isDigit((char)n4)) {
                    System.err.println("Font3DChar.getNDigitInt: error while reading font file");
                    return -1;
                }
                cArray[n3] = (char)n4;
                ++n3;
            }
        }
        catch (IOException iOException) {
            System.err.println("Font3DChar.getNDigitInt: IO exception while reading font file");
            return -1;
        }
        n4 = 0;
        while (n4 < n) {
            if (Character.isDigit(cArray[n4])) break;
            ++n4;
        }
        if (n4 == n) {
            return -1;
        }
        n3 = n4 + 1;
        while (n3 < n) {
            if (!Character.isDigit(cArray[n3])) break;
            ++n3;
        }
        int n5 = --n3 + 1;
        while (n5 < n) {
            if (cArray[n5] != ' ') {
                return -1;
            }
            ++n5;
        }
        String string = new String(cArray).substring(n4, n3 + 1);
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
        return n2;
    }
}

